%     NIT     NATURE INSPIRED TOOLBOX

% ======================================================
%   PROGRAM AIM :
%         TO READS NI SYSTEM FILE TO RETURN STRUCTURE
% ======================================================
%   USAGE :
%         1. out = rdnit('fileName.PSO')
%         2. out = rdnit
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function out = rdnit(fileName)

out=[];
if nargin < 1
    [fileName, pathName] = uigetfile( ...
        {'*.PSO; *.GA; *.ACO; *.ACO', 'NIT Files (*.PSO,*.GA,*.ACO,*.BBO)';
        '*.PSO', 'Particle Swarm Optimization files (*.PSO)'; ...
        '*.GA','Genetic Algorithms file (*.GA)'; ...
        '*.ACO','Ant Colony Optimization files (*.ACO)'; ...
        '*.BBO','Biogeoraphical Based Optimization (*.BBO)'; ...
        '*.*',  'All Files (*.*)'}, ...
        'Pick an NIT File');
    [pathName fileName extn ver] = fileparts([pathName fileName]);
    if fileName==0 | pathName==0
        error('No file was loaded');
    end
elseif ~isstr(fileName)
    error('File name must be a STRING.')
else 
    [pathName fileName extn ver] = fileparts(fileName);
end

fileName = strtok(deblank(fileName),'.');
if isempty(fileName),
    if nargout<2
        error('Empty file name: No File Loaded');
    end
    return
end
fileName=[fileName extn];
[fid errorStr]=fopen(fileName, 'r');
if fid < 0
    if nargout < 2
        error('Empty file name: No File Loaded');
    end
    return
end

nit.Name='Untitled';
nit.Type='PSO';

endLine = '[';
while ~feof(fid) 
   nextLine = fgetl(fid);
   if findstr(nextLine, endLine)==1
      continue;
   end
   eval([nextLine ';']);
end
fclose(fid);

out = nit;